#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
digital paneo article configure 
~~~~~
:copyright: (c) 2012 by interlogic
"""
#ARTICLES CONFIGURE
ARTICLES_TYPE = ( 
{
    #---------------------------------------------------
    #NEWSは共通の標準コンテツです削除しないでください。
    #---------------------------------------------------
    'id':1,                 #変更不可
    'prefix':'news',
    'title':u'標準コンテンツ',
    'idx':'00',
    'group':[
        {'code':'0000','idx':0,'parent':None,'label':u'未設定'},     
    ],
    'group_delete':[],      #削除するcodeを指定します。
    'category':[
        {'code':'0000','idx':0,'parent':None,'label':u'未設定'}, 
    ],
    'category_delete':[],   #削除するcodeを指定します。
},

{
    'id':100,               #変更不可
    'prefix':'builder',
    'title':u'工務店情報',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
    ],
    'category_delete':[],
},

{
    'id':200,               #変更不可
    'prefix':'catalog',
    'title':u'カタログ情報',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
        {'code':'0010','parent':None,'label':u'こだわり','idx':10},     
        {'code':'0020','parent':None,'label':u'さまざまな住み方','idx':20},     
        {'code':'0030','parent':None,'label':u'子育て中心','idx':30},     
        {'code':'0040','parent':None,'label':u'自然素材','idx':40},     
        {'code':'0050','parent':None,'label':u'カシコク建てる','idx':50},     
    ],
    'category_delete':[],
},

{
    'id':210,               #変更不可
    'prefix':'etc_catalog',
    'title':u'関連カタログ情報',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
        {'code':'0010','parent':None,'label':u'住宅ローン','idx':10},     
        {'code':'0020','parent':None,'label':u'火災保険','idx':20},     
        {'code':'0030','parent':None,'label':u'セキュリティ','idx':30},     
        {'code':'0040','parent':None,'label':u'引越し','idx':40},     
        {'code':'0050','parent':None,'label':u'家具','idx':50},     
        {'code':'0060','parent':None,'label':u'太陽光発電','idx':60},     
        {'code':'0070','parent':None,'label':u'クリーニング','idx':70},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
    ],
    'category_delete':[],
},

{
    'id':300,               #変更不可
    'prefix':'event',
    'title':u'イベント情報',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
		{'code':'0010','parent':None,'label':u'イベント','idx':1},     
		{'code':'0020','parent':None,'label':u'見学会','idx':2},     
		{'code':'0030','parent':None,'label':u'セミナー','idx':3},     
        {'code':'0040','parent':None,'label':u'プレゼント','idx':4},     
    ],
    'category_delete':[],
},

{
    'id':400,               #変更不可
    'prefix':'osusume',
    'title':u'おすすめ物件情報',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
        {'code':'0001','parent':None,'label':u'土地情報','idx':1},     
        {'code':'0002','parent':None,'label':u'建物情報','idx':2},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
        {'code':'0010','parent':None,'label':u'新築一戸建て','idx':1}, 
        {'code':'0020','parent':None,'label':u'中古一戸建て','idx':2}, 
        {'code':'0030','parent':None,'label':u'新築マンション','idx':3}, 
        {'code':'0040','parent':None,'label':u'中古マンション','idx':4}, 
        {'code':'0050','parent':None,'label':u'店舗物件','idx':5}, 
    ],
    'category_delete':[],
},
{
    'id':500,               #変更不可
    'prefix':'blog',
    'title':u'住まいのブログ',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
        {'code':'0010','parent':None,'label':u'カシコク家を建てる','idx':10}, 
        {'code':'0020','parent':None,'label':u'やっぱり自然派、天然派','idx':20}, 
        {'code':'0030','parent':None,'label':u'とことんこだわる','idx':30}, 
        {'code':'0040','parent':None,'label':u'おもいっきり子育てしよ','idx':40}, 
        {'code':'0050','parent':None,'label':u'家族いろいろ住み方いろいろ','idx':50}, 
        {'code':'0060','parent':None,'label':u'とっておきLiving+Kitchen','idx':60}, 
        {'code':'0070','parent':None,'label':u'建築びっくりな経験','idx':70}, 
    ],
    'category_delete':[],
},
{
    'id':600,               #変更不可
    'prefix':'present',
    'title':u'総合館プレゼント',
    'idx':'01',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
    ],
    'category_delete':[],
},
{
    'id':900,               #変更不可
    'prefix':'house',
    'title':u'施工事例',
    'idx':'02',
    'group':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
    ],
    'group_delete':[],
    'category':[
        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
    ],
    'category_delete':[],
},


#{
#    'id':300,#変更不可
#    'prefix':'sample',
#    'title':u'サンプル記事タイプ情報',
#    'idx':'01',
#    'group':[
#        {'code':'0000','parent':None,'label':u'未設定','idx':0},     
#    ],
#    'group_delete':[],
#    'category':[
#        {'code':'0000','parent':None,'label':u'未設定','idx':0}, 
#    ],
#    'category_delete':[],
#},
)

ARTICLES = (    
{
    #---------------------------------------------------
    #NEWSは共通の標準コンテツです削除しないでください。
    #---------------------------------------------------
    'type'              :1,                 #ARTILES_TYPEのid
    'id'                :1,                 #変更不可(重複不可)
    'prefix'            :'news',            #記事のプリフィック
    #---------------------------
    'title'             :u'新着情報',       #記事名
    'template_set'      :'news',    #templateフォルダ名
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'news00+-',
    'active'            :True,
},
{
    #---------------------------------------------------
    #NEWSは共通の標準コンテツです削除しないでください。
    #---------------------------------------------------
    'type'              :1,                 #ARTILES_TYPEのid
    'id'                :2,                 #変更不可(重複不可)
    'prefix'            :'special',            #記事のプリフィック
    #---------------------------
    'title'             :u'特集記事',       #記事名
    'template_set'      :'special',    #templateフォルダ名
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'special00+-',
    'active'            :True,
},

{
    #---------------------------
    'type'              :100,               #ARTILES_TYPEのid
    'id'                :101,                 #変更不可(※重複がないか確認)
    'prefix'            :'builder',
    #---------------------------
    'title'             :u'工務店紹介',
    'template_set'      :'builder',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'builder00+-',
    'active'            :True,
},
{
    #---------------------------
    'type'              :200,               #ARTILES_TYPEのid
    'id'                :201,               #変更不可(※重複がないか確認)
    'prefix'            :'catalog',
    #---------------------------
    'title'             :u'住宅カタログ',
    'template_set'      :'catalog',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'event00+-',
    'active'            :True,
},
{
    #---------------------------
    'type'              :210,               #ARTILES_TYPEのid
    'id'                :211,               #変更不可(※重複がないか確認)
    'prefix'            :'etc_catalog',
    #---------------------------
    'title'             :u'関連カタログ',
    'template_set'      :'etc_catalog',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'event00+-',
    'active'            :True,
},
{
    #---------------------------
    'type'              :300,               #ARTILES_TYPEのid
    'id'                :301,               #変更不可(※重複がないか確認)
    'prefix'            :'event',
    #---------------------------
    'title'             :u'イベント',
    'template_set'      :'event',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'event00+-',
    'active'            :True,
},
{
    #---------------------------
    'type'              :400,               #ARTILES_TYPEのid
    'id'                :401,               #変更不可(※重複がないか確認)
    'prefix'            :'osusume',
    #---------------------------
    'title'             :u'おすすめ物件',
    'template_set'      :'osusume',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'osusume00+-',
    'active'            :True,
},
{
    #---------------------------
    'type'              :500,               #ARTILES_TYPEのid
    'id'                :501,               #変更不可(※重複がないか確認)
    'prefix'            :'blog',
    #---------------------------
    'title'             :u'住まいのブログ',
    'template_set'      :'blog',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'blog00+-',
    'active'            :True,
},
{
    #---------------------------
    'type'              :600,               #ARTILES_TYPEのid
    'id'                :601,               #変更不可(※重複がないか確認)
    'prefix'            :'present',
    #---------------------------
    'title'             :u'書籍&グッズ',
    'template_set'      :'present',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'present00+-',
    'active'            :True,
},

#===================================================================================
#施工事例
#===================================================================================
{
    #---------------------------
    'type'              :900,               #ARTILES_TYPEのid
    'id'                :901,               #変更不可(※重複がないか確認)
    'prefix'            :'test',
    #---------------------------
    'title'             :u'テスト工務店',
    'template_set'      :'house',
    'template_system_use':True,             #PANEOシステムフォルダテンプレートの利用
    'default_template'  :'skelton',
    'password'          :'0000',
    'active'            :True,
},
)
